# 运算符
算术运算符：`+, -, *, /, //, %, **`
比较运算符：`==, !=, <=, >=, <, >`
布尔运算符：`not, and, or`

注意：游戏中的所有数字都是浮点数。因此，所有的算术运算符都是浮点运算符。
`//` 的定义是在除法后对数字向下取整。

若要使用赋值运算符，需要先解锁“变量”解锁项。

## 介绍
运算符可以用来对值进行比较、修改和组合。
算术运算符 `+, -, *, /, //, %, **` 用于对数字执行常见的数学运算。
比较运算符 `==, !=, <=, >=, <, >` 用于比较值。结果始终为 `True` 或 `False`。
逻辑运算符（也称为布尔运算符）`not, and, or` 用于组合真值。

## 算术运算符
`+` 和 `-` 用于加法和减法。

`2 + 3` 的结果是 `5`
`3 - 2` 的结果是 `1`

`*`、`/` 和 `//` 用于乘法和除法。

`2 * 3` 的结果是 `6`
`5 / 2` 的结果是 `2.5`

`//` 的作用与 `/` 相同，但结果会向下取整（舍入到下一个整数）。

`5 // 2` 的结果是 `2`

`%` 是模运算符，也称为取余运算符。它本质上是将两个数相除后返回余数。你也可以把它想象成从左边的数中反复减去右边的数，直到余数小于右边的数。

`4 % 2` 的结果是 `0`
`5 % 2` 的结果是 `1`
`6 % 2` 的结果是 `0`
`2 % 6` 的结果是 `2`
`1.5 % 1` 的结果是 `0.5`

`**` 是幂运算符。

`2**2` 的结果是 `4`
`(-5)**3` 的结果是 `-125`

## 比较运算符
`==` 和 `!=` 用于检查两个值是“相等”(`==`) 还是“不相等”(`!=`)。它们可以用于所有类型的值。

`2 == 2` 的结果是 `True`
`Entities.Bush != Entities.Bush` 的结果是 `False`
`3 != 3 + 1` 的结果是 `True`

`<=, >=, <, >` 只能用于数字。它们检查左边的数是“小于或等于”(`<=`)、“大于或等于”(`>=`)、“小于”(`<`) 还是“大于”(`>`) 右边的数。

`1 <= 1` 的结果是 `True`
`2 >= 3` 的结果是 `False`
`-2 < -1` 的结果是 `True`
`6 > 6` 的结果是 `False`

## 逻辑运算符
`not` 只是简单地反转值：

`not False` 的结果是 `True`
`not True` 的结果是 `False`

`and` 仅在两个值都为 `True` 时，结果才为 `True`

`True and True` 的结果是 `True`
`True and False` 的结果是 `False`
`False and False` 的结果是 `False`

`or` 如果至少有一个值为 `True`，结果就为 `True`

`True or True` 的结果是 `True`
`True or False` 的结果是 `True`
`False or False` 的结果是 `False`